#include <windows.h>
#include <windowsx.h>
#include <commctrl.h>
#include <stdio.h>
#include <tchar.h>
#define nobreak
#define elemof(x) (sizeof(x)/sizeof(*(x)))
#define T(x) TEXT(x)

static HWND MainWnd,Status;
static HINSTANCE Inst;

#ifdef _DEBUG
#define debug(x) DebugOut x
static void _cdecl DebugOut(const char*t, ...) {
 char s[256];
 lstrcpyA(s+_vsnprintf(s,sizeof(s)-3,t,(va_list)(&t+1)),"\r\n");
 OutputDebugStringA(s);
}
#else
#define debug(x)
#endif

static void Line(HDC dc, int x1, int y1, int x2, int y2) {
 POINT pt[2]={{x1,y1},{x2,y2}};
 Polyline(dc,pt,2);
}

static const POINT baum[]={
 {49,-6},{-119,-19},{-165,-34},{-195,-74},{-165,-129},{-112,-153},{-106,-167},{-55,-189},
 {-4,-242},{-6,-258},{-47,-324},{-38,-345},{25,-377},{44,-362},{51,-369},{70,-343},
 {83,-339},{97,-328},{119,-333},{140,-318},{144,-326},{161,-326},{167,-318},{189,-328},
 {212,-328},{237,-371},{252,-371},{261,-364},{258,-364},{284,-380},{270,-392},{273,-400},
 {283,-409},{297,-406},{316,-409},{316,-414},{333,-416},{341,-441},{352,-455},{345,-464},
 {355,-475},{369,-477},{378,-483},{370,-494},{375,-502},{378,-533},{356,-527},{350,-519},
 {333,-522},{322,-520},{302,-516},{288,-509},{280,-502},{270,-503},{264,-495},{231,-495},
 {233,-513},{223,-514},{219,-505},{205,-522},{194,-530},{183,-528},{172,-517},{134,-503},
 {117,-498},{116,-489},{120,-489},{134,-472},{138,-463},{134,-450},{125,-456},{108,-455},
 {98,-448},{98,-445},{80,-450},{41,-428},{31,-431},{0,-409},{-11,-408},{-19,-398},
 {-25,-400},{-47,-392},{-66,-392},{-66,-402},{-75,-402},{-80,-411},{-83,-422},{-83,-438},
 {-80,-455},{-75,-469},{-69,-470},{-52,-484},{-48,-495},{-39,-509},{-25,-527},{-19,-533},
 {-3,-539},{0,-534},{0,-519},{-9,-500},{-3,-503},{-8,-491},{-2,-483},{13,-480},
 {25,-469},{36,-472},{39,-481},{59,-494},{69,-494},{70,-503},{78,-508},{88,-514},
 {111,-498},{116,-528},{122,-544},{127,-548},{138,-541},{155,-541},{170,-545},{175,-555},
 {192,-548},{200,-561},{208,-566},{220,-566},{220,-572},{200,-578},{191,-575},{175,-575},
 {172,-577},{139,-577},{131,-578},{117,-569},{91,-580},{84,-577},{69,-567},{56,-555},
 {44,-553},{39,-558},{38,-583},{17,-586},{22,-609},{13,-611},{8,-594},{8,-589},
 {2,-584},{-20,-583},{-22,-588},{-34,-588},{-44,-592},{-52,-608},{-63,-614},{-75,-616},
 {-83,-620},{-92,-620},{-102,-608},{-106,-591},{-127,-584},{-138,-575},{-144,-575},{-161,-586},
 {-163,-594},{-178,-591},{-181,-591},{-192,-580},{-198,-588},{-216,-581},{-228,-584},{-241,-591},
 {-250,-594},{-255,-594},{-256,-581},{-255,-570},{-261,-561},{-266,-564},{-269,-561},{-273,-561},
 {-273,-566},{-281,-569},{-292,-544},{-309,-558},{-314,-570},{-314,-581},{-320,-580},{-323,-577},
 {-328,-566},{-336,-547},{-345,-548},{-341,-536},{-333,-530},{-331,-523},{-328,-519},{-327,-516},
 {-319,-511},{-317,-502},{-341,-505},{-355,-509},{-364,-506},{-369,-503},{-364,-495},{-355,-500},
 {-341,-492},{-328,-486},{-320,-486},{-309,-480},{-302,-480},{-298,-484},{-284,-473},{-291,-467},
 {-275,-470},{-258,-461},{-234,-461},{-228,-459},{-223,-461},{-217,-469},{-220,-483},{-198,-483},
 {-195,-477},{-189,-483},{-169,-484},{-169,-498},{-158,-505},{-150,-500},{-134,-519},{-123,-514},
 {-113,-514},{-108,-508},{-108,-500},{-123,-483},{-131,-470},{-136,-458},{-138,-445},{-131,-434},
 {-138,-431},{-147,-420},{-144,-406},{-139,-391},{-139,-383},{-144,-375},{-152,-370},{-169,-367},
 {-183,-364},{-188,-370},{-192,-370},{-202,-361},{-203,-367},{-220,-355},{-222,-363},{-236,-359},
 {-242,-366},{-238,-372},{-238,-383},{-244,-388},{-245,-397},{-255,-397},{-255,-400},{-236,-400},
 {-231,-392},{-225,-392},{-222,-414},{-214,-414},{-206,-423},{-197,-423},{-191,-428},{-183,-430},
 {-180,-444},{-191,-455},{-203,-453},{-214,-453},{-219,-461},{-222,-458},{-222,-447},{-231,-441},
 {-234,-447},{-252,-439},{-258,-436},{-266,-436},{-275,-438},{-283,-442},{-286,-445},{-286,-455},
 {-298,-455},{-306,-463},{-314,-464},{-320,-455},{-320,-448},{-327,-442},{-334,-445},{-341,-441},
 {-345,-434},{-352,-434},{-355,-444},{-356,-447},{-369,-448},{-370,-459},{-375,-466},{-380,-466},
 {-381,-458},{-400,-459},{-395,-445},{-386,-422},{-380,-408},{-383,-400},{-373,-400},{-370,-384},
 {-363,-388},{-355,-375},{-348,-367},{-338,-366},{-330,-366},{-331,-355},{-338,-352},{-342,-355},
 {-348,-353},{-364,-364},{-363,-372},{-369,-375},{-370,-370},{-380,-370},{-386,-378},{-400,-380},
 {-405,-384},{-416,-384},{-419,-392},{-419,-397},{-411,-397},{-416,-419},{-434,-422},{-441,-419},
 {-445,-414},{-455,-414},{-467,-417},{-470,-414},{-461,-408},{-456,-400},{-453,-395},{-453,-408},
 {-431,-409},{-430,-402},{-430,-398},{-436,-394},{-430,-388},{-428,-384},{-441,-377},{-433,-363},
 {-425,-361},{-417,-356},{-416,-355},{-416,-350},{-420,-350},{-420,-336},{-431,-341},{-434,-336},
 {-447,-336},{-438,-322},{-445,-319},{-441,-316},{-441,-313},{-450,-314},{-444,-305},{-439,-305},
 {-438,-298},{-433,-294},{-434,-286},{-433,-277},{-414,-277},{-409,-269},{-395,-269},{-391,-267},
 {-391,-264},{-391,-256},{-397,-250},{-386,-255},{-378,-245},{-367,-231},{-358,-225},{-348,-228},
 {-319,-227},{-311,-231},{-302,-244},{-289,-247},{-281,-236},{-278,-230},{-275,-233},{-266,-219},
 {-245,-214},{-238,-219},{-231,-222},{-230,-228},{-222,-234},{-223,-247},{-214,-250},{-206,-258},
 {-220,-275},{-227,-267},{-233,-277},{-242,-280},{-242,-284},{-264,-284},{-258,-297},{-244,-297},
 {-242,-294},{-234,-298},{-233,-292},{-222,-302},{-213,-294},{-209,-300},{-209,-306},{-202,-317},
 {-184,-320},{-178,-313},{-177,-306},{-170,-306},{-170,-311},{-158,-311},{-150,-305},{-150,-298},
 {-161,-289},{-159,-280},{-152,-280},{-145,-284},{-145,-295},{-136,-295},{-130,-288},{-128,-278},
 {-133,-273},{-123,-267},{-123,-256},{-128,-245},{-139,-238},{-147,-230},{-156,-225},{-170,-214},
 {-183,-205},{-191,-200},{-225,-186},{-255,-177},{-267,-167},{-298,-141},{-316,-117},{-322,-114},
 {-328,-92},{-344,-73},{-359,-61},{-367,-58},{-384,-42},{-398,-27},{-413,-17},{-425,-8},
 {-494,-6},{-494,0},{49,0},

 {-219,-19},{-205,-23},{-202,-31},{-214,-47},{-219,-66},{-219,-86},{-208,-103},{-195,-111},
 {-188,-122},{-191,-127},{-200,-128},{-205,-119},{-216,-114},{-231,-95},{-242,-70},{-242,-47},
 {-242,-38},{-231,-28},{-222,-17},

 {-284,-13},{-270,-23},{-263,-31},{-263,-58},{-270,-61},{-277,-56},{-280,-41},{-286,-31},
 {-291,-20},{-289,-14},

 {-353,-11},{-342,-14},{-325,-28},{-298,-56},{-281,-91},{-277,-98},{-259,-114},{-259,-122},
 {-272,-133},{-281,-133},{-292,-125},{-292,-111},{-297,-111},{-300,-94},{-311,-81},{-319,-63},
 {-333,-45},{-344,-36},{-352,-34},{-348,-28},{-355,-23},{-359,-28},{-363,-25},{-356,-13},

 {-292,-314},{-267,-313},{-248,-322},{-248,-338},{-258,-339},{-267,-355},{-275,-356},{-280,-352},
 {-275,-344},{-280,-333},{-291,-325},{-297,-325},{-298,-316},

 {106,-364},{113,-369},{108,-383},{94,-400},{81,-405},{70,-402},{63,-406},{48,-406},
 {42,-402},{41,-391},{36,-384},{41,-378},{48,-373},{53,-367},{69,-373},{84,-373},
 {98,-366},

 {166,-394},{178,-409},{208,-419},{223,-419},{238,-419},{244,-422},{266,-442},{264,-447},
 {241,-448},{230,-438},{208,-434},{161,-438},{145,-430},{136,-433},{113,-419},{113,-413},
 {127,-402},{125,-402},{138,-403},{147,-398},{158,-402},
};

static const int ecken[]={451,19,10,24,13,17,21};

static void MaleBunt(HDC dc,bool meta=false) {
 SetGraphicsMode(dc,GM_ADVANCED);
 SetBkMode(dc,TRANSPARENT);

 HFONT f0,f1;
 HBRUSH b0,b1;
 HPEN p0,p1;

 p1=CreatePen(PS_NULL,0,0);
 p0=SelectPen(dc,p1);

 if (!meta) Rectangle(dc,-1000,-800,1000,400);	// x-extent: 2000, y-extent: 1200

 b1=CreateSolidBrush(RGB(232,123,20));
 b0=SelectBrush(dc,b1);

 Chord(dc,-700,-700,700,700,1000,0,-1000,0);

 b1=GetStockBrush(BLACK_BRUSH);
 DeleteObject(SelectBrush(dc,b1));

// BeginPath(dc);
// static const POINT baum[]={
//  {0,0},{-100,-100},{-200,-100},{-300,0},
//  {-200,50},{-600,200},{600,200}};
// PolyBezier(dc,baum,elemof(baum));
 PolyPolygon(dc,baum,ecken,7);
// CloseFigure(dc);
// static const POINT wurzel[]={
//  {-100,0},{-10,-200},{-500,-100},{-300,-200},
//  {-200,-50},{-100,200},{-600,200}};
// PolyBezier(dc,wurzel,elemof(wurzel));
// CloseFigure(dc);

// EndPath(dc);
// StrokeAndFillPath(dc);

 static const LOGBRUSH lb={BS_SOLID,0,0};
 p1=ExtCreatePen(PS_GEOMETRIC|PS_SOLID|PS_ENDCAP_FLAT|PS_JOIN_MITER,10,&lb,0,NULL);
 DeletePen(SelectPen(dc,p1));

 Line(dc,-1000,0,1000,0);

 f1=CreateFont(meta?420:450,0,0,0,0,0,0,0,DEFAULT_CHARSET,OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,DEFAULT_PITCH,
   "Nyala");
 f0=SelectFont(dc,f1);
 SetTextAlign(dc,TA_UPDATECP|TA_BASELINE|TA_LEFT);
 MoveToEx(dc,-950,300,NULL);
 TextOutW(dc,0,0,L"TU C",4);

 f1=CreateFont(meta?310:350,0,0,0,0,0,0,0,DEFAULT_CHARSET,OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,DEFAULT_PITCH,
   "Nyala");
 DeleteObject(SelectFont(dc,f1));
 TextOutW(dc,0,0,L"HEMNITZ",7);

 f1=CreateFont(250,0,2700,0,FW_BOLD,0,0,0,DEFAULT_CHARSET,OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,DEFAULT_PITCH,
   "FangSong");
 DeleteObject(SelectFont(dc,f1));
 SetTextAlign(dc,TA_LEFT|VTA_CENTER|VTA_BASELINE);
 TextOutW(dc,+850,-395,L"\x677E\x6FE4\x9928",3);
 TextOutW(dc,-850,-395,L"\x7A7A\x624B\x9053",3);

 DeleteFont(SelectFont(dc,f0));
 DeletePen(SelectPen(dc,p0));
 /*DeleteBrush(*/SelectBrush(dc,b0)/*)*/;
}

static void MaleSW(HDC dc,bool meta=false) {
 SetGraphicsMode(dc,GM_ADVANCED);
 SetBkMode(dc,TRANSPARENT);

 HFONT f0,f1;
 HBRUSH b0;
 HPEN p0,p1;

 p1=CreatePen(PS_SOLID,12,0);
 p0=SelectPen(dc,p1);

 if (!meta) Rectangle(dc,-1000,-750,1000,250);	// x-extent: 2000, y-extent: 1200

 b0=SelectBrush(dc,GetStockBrush(HOLLOW_BRUSH));

 BeginPath(dc);

 Chord(dc,-700,-700,700,700,1000,0,-1000,0);

 PolyPolygon(dc,baum,ecken,7);

 EndPath(dc);
 StrokeAndFillPath(dc);

 f1=CreateFont(320,0,0,0,0,0,0,0,DEFAULT_CHARSET,OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,DEFAULT_PITCH,
   "Nyala");
 f0=SelectFont(dc,f1);
 SetTextAlign(dc,TA_UPDATECP|TA_BASELINE|TA_LEFT);
 MoveToEx(dc,-650,200,NULL);
 TextOutW(dc,0,0,L"TU C",4);

 f1=CreateFont(220,0,0,0,0,0,0,0,DEFAULT_CHARSET,OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,DEFAULT_PITCH,
   "Nyala");
 DeleteObject(SelectFont(dc,f1));
 TextOutW(dc,0,0,L"HEMNITZ",7);

 f1=CreateFont(320,0,2700,0,FW_BOLD,0,0,0,DEFAULT_CHARSET,OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,DEFAULT_PITCH,
   /*"MS Mincho"/*"MingLiU"/*/"FangSong");
 DeleteObject(SelectFont(dc,f1));
 SetTextAlign(dc,TA_LEFT|VTA_CENTER|VTA_BASELINE);
 TextOutW(dc,+840,-250,L"\x677E\x6FE4\x9928",3);
 TextOutW(dc,-840,-250,L"\x7A7A\x624B\x9053",3);

 DeleteFont(SelectFont(dc,f0));
 DeletePen(SelectPen(dc,p0));
 SelectBrush(dc,b0);
}

static POINT wpo;
static SIZE wpe;

bool bunt;

static void Male(HDC dc, int cx, int cy) {
 SetMapMode(dc,MM_ISOTROPIC);
 SetWindowExtEx(dc,1000,1000,NULL);
 SetViewportOrgEx(dc,cx>>1,MulDiv(cy,7,10),NULL);
 SetViewportExtEx(dc,cx>>1,MulDiv(cy,10,12),NULL);
 GetViewportOrgEx(dc,&wpo);
 GetViewportExtEx(dc,&wpe);
 if (bunt) MaleBunt(dc); else MaleSW(dc);
/*
 HBITMAP m1,m0;
 m1=(HBITMAP)LoadImage(0,T("Stempel.bmp"),IMAGE_BITMAP,0,0,LR_LOADFROMFILE);
 BITMAP bm;
 GetObject(m1,sizeof(bm),&bm);
 HDC dcs=CreateCompatibleDC(dc);
 m0=SelectBitmap(dcs,m1);
 StretchBlt(dc,-700,-700,1400,700,dcs,0,0,bm.bmWidth,bm.bmHeight,SRCINVERT);
 DeleteBitmap(SelectBitmap(dcs,m0));
 DeleteDC(dcs);*/
}

static LPARAM CALLBACK MainWndProc(HWND Wnd, UINT Msg, WPARAM wParam, LPARAM lParam) {
 switch (Msg) {
  case WM_CREATE: {
   Status=CreateWindowEx(0,T("msctls_StatusBar32"),NULL,WS_CHILD|WS_VISIBLE,0,0,0,0,Wnd,(HMENU)3,Inst,NULL);
   static const int widths[]={100,200,350,500,-1};
   SendMessage(Status,SB_SETPARTS,elemof(widths),(LPARAM)widths);
//   HDC dc=CreateMetaFile(T("skglogo.wmf"));
//   MaleBunt(dc);
//   DeleteMetaFile(CloseMetaFile(dc));
   RECT r;
   SetRect(&r,
     MulDiv(-1000,35,1),
     MulDiv(-800, 35,1),
     MulDiv( 1000,35,1),
     MulDiv( 400, 35,1));
   HDC dc=CreateEnhMetaFile(0,T("skglogo.emf"),&r,NULL);
   MaleBunt(dc,true);
   DeleteEnhMetaFile(CloseEnhMetaFile(dc));
   SetRect(&r,
     MulDiv(-1000,35,1),
     MulDiv(-750, 35,1),
     MulDiv( 1000,35,1),
     MulDiv( 250, 35,1));
   dc=CreateEnhMetaFile(0,T("skglogo_sw.emf"),&r,NULL);
   MaleSW(dc,true);
   DeleteEnhMetaFile(CloseEnhMetaFile(dc));
  }break;

  case WM_PAINT: {
   PAINTSTRUCT ps;
   BeginPaint(Wnd,&ps);
   SendMessage(Wnd,WM_PRINTCLIENT,(WPARAM)ps.hdc,0);
   EndPaint(Wnd,&ps);
  }return 0;

  case WM_PRINTCLIENT: {
   int h;
   RECT r;
   GetWindowRect(Status,&r);
   h=r.bottom-r.top;
   GetClientRect(Wnd,&r);
   Male((HDC)wParam,r.right,r.bottom-h);
  }return 0;

  case WM_SIZE: {
   SendMessage(Status,Msg,wParam,lParam);
  }break;

  case WM_MOUSEMOVE: {
   POINT pt;
   pt.x=MulDiv(GET_X_LPARAM(lParam)-wpo.x,1000,wpe.cx);
   pt.y=MulDiv(GET_Y_LPARAM(lParam)-wpo.y,1000,wpe.cy);
   TCHAR s[32];
   s[_sntprintf(s,elemof(s)-1,T("%d/%d ScrPix"),pt.x,pt.y)]=0;
   SendMessage(Status,SB_SETTEXT,1,(LPARAM)s);
  }break;

  case WM_LBUTTONDOWN: {
   POINT pt;
   pt.x=MulDiv(GET_X_LPARAM(lParam)-wpo.x,1000,wpe.cx);
   pt.y=MulDiv(GET_Y_LPARAM(lParam)-wpo.y,1000,wpe.cy);
   FILE *f=fopen("ttt","a");
   fprintf(f,"{%d,%d},",pt.x,pt.y);
   fclose(f);
   TCHAR s[32];
   static int num;
   s[_sntprintf(s,elemof(s)-1,T("%d"),++num)]=0;
   SendMessage(Status,SB_SETTEXT,0,(LPARAM)s);
  }break;

  case WM_RBUTTONDOWN: {
   FILE *f=fopen("ttt","a");
   fprintf(f,"\n");
   fclose(f);
  }break;

  case WM_CHAR: switch (wParam) {
   case ' ': bunt=!bunt; InvalidateRect(Wnd,NULL,TRUE); break;
  }break;

  case WM_CLOSE: {
   PostQuitMessage(0);
  }break;
 }
 return DefWindowProc(Wnd,Msg,wParam,lParam);
}

EXTERN_C void WinMainCRTStartup() {
 Inst=GetModuleHandle(NULL);
 InitCommonControls();

 WNDCLASSEX wc;
 ZeroMemory(&wc,sizeof(wc));
 wc.cbSize=sizeof(wc);
 wc.hbrBackground=(HBRUSH)(COLOR_APPWORKSPACE+1);
 wc.style=CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS;
 wc.hInstance=Inst;
 wc.hCursor=LoadCursor(0,IDC_ARROW);
 wc.hIcon=LoadIcon(0,IDI_APPLICATION);
 wc.lpfnWndProc=MainWndProc;
 wc.lpszClassName="skg";
 RegisterClassEx(&wc);

 MainWnd=CreateWindowEx(0,"skg",NULL,WS_OVERLAPPEDWINDOW,
   CW_USEDEFAULT,0,CW_USEDEFAULT,0,
   0,0,Inst,NULL);
 ShowWindow(MainWnd,SW_SHOWDEFAULT);
 MSG msg;
 while (GetMessage(&msg,0,0,0)) {
  TranslateMessage(&msg);
  DispatchMessage(&msg);
 }
 ExitProcess(msg.wParam);
}
